package gov.va.vamf.scheduling.direct.datalayer.appointment;

import com.agilex.healthcare.directscheduling.datalayer.SchedulingDataLayer;
import com.agilex.healthcare.directscheduling.domain.AppointmentSlotFilter;
import com.agilex.healthcare.directscheduling.domain.BookedAppointments;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

@Component
@Service
public class AppointmentDataService {
    @Resource
    SchedulingDataLayer schedulingDataLayer;

    @Resource
    PatientIdentifiersDataService patientIdentifiersDataService;


    public BookedAppointments retrieveBookedAppointments(PatientIdentifier edipiPatientIdentifier, String siteCode,
                                                         Date startDate) {
        PatientIdentifier icnPatientIdentifier = patientIdentifiersDataService.getIcnIdentifier(edipiPatientIdentifier);
        if (icnPatientIdentifier == null) {
            return null;
        }

        AppointmentSlotFilter appointmentSlotFilter = new AppointmentSlotFilter();
        appointmentSlotFilter.setPatientIdentifier(icnPatientIdentifier);
        appointmentSlotFilter.setPatientId(icnPatientIdentifier.getUniqueId());
        appointmentSlotFilter.setSiteCode(siteCode);
        appointmentSlotFilter.setStartDate(startDate);

        return schedulingDataLayer.getPatientBookedAppointments(appointmentSlotFilter);
    }
}
